﻿// See https://aka.ms/new-console-template for more information

using System.Net.Http.Json;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Threading.Tasks;
using System.IO;
using System.Text.Json.Serialization;

class Program
{
    public class User
    {
        [JsonPropertyName("id")]
        public int Id { get; set; } // transformation des variables en objet JSON via get et set

        [JsonPropertyName("username")]
        public string Username { get; set; }

        [JsonPropertyName("email")]
        public string Email { get; set; }

        public User(int id, string NomUtilisateur, string Email)
        {
            this.Id = id;
            this.Username = NomUtilisateur;
            this.Email = Email;
        }

        static async Task Main(string[] args)
    {


        using HttpClient client = new HttpClient();

        var response = client.GetAsync("http://localhost:12021/cartads/api/client/clients").Result; // fournir la page dont je veux reprendre les valeurs sous forme de variable

        if (response.IsSuccessStatusCode)
        {
            Console.WriteLine(response.Headers.CacheControl.ToString());
            var responseContent = response.Content.ReadAsStringAsync().Result;// je déclare une variable récupére le content de ma requête seulement
            var clients = System.Text.Json.JsonSerializer.Deserialize<Dictionary<string, string>>(responseContent); // Je déclare une variabe dont le contenus est sous forme de dictionnaire, je le spécifie 

            foreach (var c in clients)
            {
                Console.WriteLine("Un client : ");
                Console.WriteLine(c.Key); //première valeur d'un dictionnaire
                Console.WriteLine(c.Value); //seconde valeur d'un dictionnaire

            }
        }
        else
        {
            Console.WriteLine("Error: " + response.StatusCode); //type d'erreur
        }

            /* var response2 = client.GetAsync("https://jsonplaceholder.typicode.com/userss").Result;
            if (response2.IsSuccessStatusCode)
            {
                Console.WriteLine(response.Headers.CacheControl.ToString());
                var responseContent = response.Content.ReadAsStringAsync().Result;// je déclare une variable récupére le content de ma requête seulement
                var users = System.Text.Json.JsonSerializer.Deserialize<users<int, string, string, string>>(responseContent); // Je déclare une variabe dont le contenus est sous forme de dictionnaire, je le spécifie 
                foreach (var u in users)
                {
                    Console.WriteLine("Get successful!");
                    Console.WriteLine("Un utilisateur : ");
                    Console.WriteLine(c.Key); //première valeur d'un dictionnaire
                    Console.WriteLine(c.Value); //seconde valeur d'un dictionnaire

                }
            }
            else
            {
                Console.WriteLine("Error: " + response.StatusCode);
            }*/



            }
    }
}

